function design = super_nested_1d(k, Q,d, name)
%% This code is learn from Chun-Lin Liu
% E-mail : cl.liu@caltech.edu
% Project website: http://systems.caltech.edu/dsp/students/clliu/SuperNested.html

N1 = floor(k/2);
N2 = k - N1;
    if (Q == 1)
        % >>>>>>>>>>>>>>>>>>>> Nested arrays <<<<<<<<<<<<<<<<<<<<
        % Please see [5].
        % [5] P. Pal and P. P. Vaidyanathan, “Nested arrays: A novel approach to array processing with enhanced degrees of freedom,?IEEE Trans. Signal Process., vol. 58, no. 8, pp. 4167?181, Aug 2010.
        S = [	1 : N1, ... % Dense ULA
				(1:N2)*(1+N1)].'; % Sparse ULA
    elseif (Q == 2)
        % >>>>>>>>>>>>>>>>>>>> Second-order super-nested arrays <<<<<<<<<<<<<<<<<<<<
        % Please see [1,3].
        % Generate (A1, B1, A2, B2) according to N1
        switch (mod(N1, 4))
            case 0
                r = N1 / 4;
                A1 = r; B1 = r - 1; A2 = r - 1; B2 = r - 2;
            case 1
                r = (N1 - 1) / 4;
                A1 = r; B1 = r - 1; A2 = r - 1; B2 = r - 1;
            case 2
                r = (N1 - 2) / 4;
                A1 = r + 1; B1 = r - 1; A2 = r; B2 = r - 2;
            case 3
                r = (N1 - 3)/4;
                A1 = r; B1 = r; A2 = r; B2 = r - 1;
            otherwise
                error('Error');
        end
        S = [   1 + 2 * (0 : A1), ...                   % X_1^{(Q)}
                (N1 + 1) - (1 + 2 * (0 : B1)), ...      % Y_1^{(Q)}
                (N1 + 1) + (2 + 2 * (0 : A2)), ...      % X_2^{(Q)}
                2 * (N1 + 1) - (2 + 2 * (0 : B2)), ...  % Y_2^{(Q)}
                (N1 + 1) * (2 : N2), ...                % Z_1^{(Q)}
                N2 * (N1 + 1) - 1                       % Z_2^{(Q)}
             ];
        S = sort(unique(S)).';
       % S1 = S;
    else
        % >>>>>>>>>>>>>>>>>>>> Qth-order super-nested arrays <<<<<<<<<<<<<<<<<<<<
        % Please see [2,4].
        if ( mod(N1, 2) == 0)
            % N1 is EVEN
            S1 = super_nested_1d(k,2,d ,'super' );
            S=S1.element_indices;
            % Determine the cutoff between X_1^{(Q)} and Y_1^{(Q)}
            for nn = 1 : length(S)-1
                if (S(nn+1) - S(nn) == 1)
                    X = S(nn);
                    break;
                end
            end
            for q = 3 : Q
                % Select X_q^{(q)} and Y_q^{(q)}
                index_XQ = (S > (q-2)*(N1+1) & S <= (q-2)*(N1+1) + X);
                index_YQ = (S > (q-2)*(N1+1) + X & S < (q-1)*(N1+1));
                XQ = S( index_XQ );
                YQ = S( index_YQ );
                if (length(XQ) >= 3 && length(YQ) >= 3)
                    if ( mod(length(XQ), 2) == 0 )
                        % With extra term
                        XQ( 2 : 2 : end-2 ) = XQ( 2 : 2 : end-2 ) + (N1+1);
                    else
                        % No extra term
                        XQ( 2 : 2 : end-1 ) = XQ( 2 : 2 : end-1 ) + (N1+1);
                    end
                    
                    if ( mod(length(YQ), 2) == 0 )
                        % With extra term
                        YQ( end-1 : -2 : 3 ) = YQ( end-1 : -2 : 3 ) + (N1+1);
                    else
                        % No extra term
                        YQ( end-1 : -2 : 2 ) = YQ( end-1 : -2 : 2 ) + (N1+1);
                    end
                    S( S == (q-1)*(N1+1) ) = (N2 + 1 - (q - 1)) * (N1 + 1) - 2^(q-1) + 1;
                    S( index_XQ ) = XQ;
                    S( index_YQ ) = YQ;
                else
                    disp(['Only up to order-', num2str(q-1), ' is defined. Return the ', num2str(q-1), 'th-order super nested array'])
                    break;
                end
            end
            
            % Sort S
            S = sort(unique(S));
        else
            % N1 is ODD
            % Check Q satisfies our conditions or not
            if (N1 < 3 * 2^Q - 1 || N2 < 3 * Q - 4)
                disp('Warning! The resultant super-nested array might not be a restricted array!')
            end
            S = [];
            for q = 1 : Q - 1
                ell = 0 : floor(((N1 + 1) / 2^q - 1) / 2);
                S = [S,	(q - 1) * (N1 + 1) + 2^(q - 1) + 2^q * ell, q * (N1 + 1) - 2^(q - 1) - 2^q * ell, ...
                        (N2 + 1 - q) * (N1 + 1) - 2^q + 1];
            end
            ell = 0 : floor( (N1 + 1) / 2^Q - 1 );
            S = [S, (Q - 1) * (N1 + 1) + 2^(Q - 1) + 2^(Q - 1) * ell, Q * (N1 + 1) - 2^(Q - 1) - 2^(Q - 1) * ell];
            S = [S, (N1 + 1) * (Q : N2)];
            S = sort(unique(S)).';
            S = S';
        end
    end



if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('Super Nested Array Q=( %d)',  Q);
elseif ~ischar(name)
    error('Name must be a string.');
end
if Q>2
    S=S';
end
c=num2str(Q);
design.element_indices = S';
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = c;
design.name = name;
end